#! /usr/bin/python
#Helper program that generates library.xml thats custom to linhes.
#Contents are read from /etc/gen_lib_xml.d
#This script should be run everytime an entry is added or removed


import os, sys, subprocess
import glob

class Gen_lib_xml:
    def __init__(self,snippit_dir,orig_theme_file):
        self.snippit_dir = snippit_dir
        self.orig_theme_file =  orig_theme_file
        self.xml_snippets=[]
        self.orig_theme_xml=[]
        self.new_xml=[]

    def get_new_xml(self):
        return self.new_xml
    def get_orig_xml(self):
        return self.orig_theme_xml
    def get_snippits(self):
        return self.xml_snippets

    def read_snippets(self):
        xml_snippets=""
        lines=[]
        try:
            os.chdir(self.snippit_dir)
        except:
            print("    gen_lib_xml: Couldn't change dir to %s" %self.snippit_dir)
            print("    Exiting")
            sys.exit(0)
        file_list=glob.glob("*.conf")
        for conf_file in file_list:
            try:
                print("    gen_lib_xml: reading in %s" %conf_file)
                f=open(conf_file,'r')
                line=f.readlines()
                f.close()
            except:
                print("    gen_lib_xml: Couldn't open %s for reading" %conf_file)
                print("    Exiting")
                sys.exit(0)
            lines.extend(line)

        if len(file_list) == 0:
            print("    gen_lib_xml:  no conf files found")
            lines = []
        self.xml_snippets = lines

    def read_orig_xml(self):
        try:
            print("    gen_lib_xml:  reading in %s" %self.orig_theme_file)
            f=open(self.orig_theme_file,'r')
            lines=f.readlines()
            f.close()

        except:
            print("    gen_lib_xml: Couldn't open %s for reading" %self.orig_theme_file)
            print("    Exiting")
            sys.exit(2)
        #print lines
        for i in lines:
            if i.strip() == "</mythmenu>":
                lines.remove(i)
                print("    gen_lib_xml:  Removing /mythmenu tag ")
                break
        self.orig_theme_xml=lines

    def make_new_xml(self):
        self.new_xml = self.orig_theme_xml + self.xml_snippets
        self.new_xml.append("</mythmenu>\n")
        pass








def write_xml(xml,filename):
    try:
        f=open(filename, 'w')
    except:
        print("    gen_lib_xml: Couldn't open %s" %(filename))
        print("    Exiting")
        sys.exit(2)
    print("    gen_lib_xml:  Writing %s" %(filename))
    for i in xml:
        f.write(i)
    f.close()

def main():
    MYTHHOME=subprocess.check_output("lh_home_check.sh").decode('utf-8').strip()
    filename="%s/.mythtv/library.xml" %MYTHHOME
    orig_theme_file="/usr/share/mythtv/themes/defaultmenu/library.xml"
    lib_xml_dir="/etc/gen_lib_xml.d/"

    lib_xml = Gen_lib_xml(lib_xml_dir,orig_theme_file)
    lib_xml.read_snippets()
    lib_xml.read_orig_xml()
    lib_xml.make_new_xml()
    lib_xml.make_new_xml()
    new_xml = lib_xml.get_new_xml()

    #a = lib_xml.get_new_xml()
    #b = lib_xml.get_orig_xml()
    #c = lib_xml.get_snippits()

    write_xml(new_xml,filename)

if __name__ == "__main__":
    main()
