#!/bin/bash

# Show all upcoming conflicts
/usr/bin/misc_upcoming_recordings.pl --recordings -1 \
                            --no_show_scheduled \
                            --heading '<h3>Recording Conflicts</h3>' \
                            --no_conflicts_message '<h3>No Recording Conflicts</h3>'

# Show all the shows recorded today
/usr/bin/misc_recent_recordings.pl --recordings=-1 --hours=24 \
                          --heading '<h3>Shows Recorded In The Last 24 Hours</h3>'

# Get Encoder that was used for recordings from the backend log
firstrun=1
loglist=`find /var/log/ -name *_mythbackend*.log*`
for i in `ls -t $loglist`
do
    if [ $firstrun -eq 1 ]; then
        echo "<h3>Encoder Information</h3><div class=\"schedule\""
        firstrun=0
    fi
    /usr/bin/misc_which_recorder.pl --noheader $i
done
