#!/bin/bash
#
# Bash script by Gene Alexander (http://www.eracc.com/contact)
# of ERA Computers & Consulting (www.eracc.com, blog.eracc.com, shopping.eracc.com)
# Written using vim, the BEST plain text file editor in all of Creation.
#
# Teach yourself bash scripting: http://tldp.org/LDP/abs/html/index.html
#
# Purpose: To check fragmentation on XFS with xfs_db and run xfs_fsr on XFS mount points that
# are above a specific fragmentation threshold.
#
# What is xfs_db? Use 'man xfs_db' to find out.
# What is xfs_fsr? Use 'man xfs_fsr' to find out.
#
# Any busy files, such as open logs on /var/log, will be skipped. To defragment logs one should
# wrap this script with another script to stop and restart logging. Or, even better, write
# one's own script just for defragmentation of the logs.
#
# Warranty: NONE. Use at your own discretion and be aware that data loss is on your head if
# you choose to use this script.
#
# License: GPL 2.0 http://www.gnu.org/licenses/gpl-2.0.html
#
# Suggested Usage: crontab file for root
# 0 0 * * * /root/bin/chkxfsfrag # Run at midnight
#
# Original Release: 2011 December 15 (Merry Christmas!)
# DO NOT ALTER HEADER FROM THIS LINE UP.
#
e='/usr/bin/echo -e'                                # Use the echo command, not built-in.
xfsfsr=/usr/bin/xfs_fsr                            # Set variable with the path to xfs_fsr.
xfsdb=/usr/bin/xfs_db                              # Set variable with the path to xfs_db.
ionice=/usr/bin/ionice                             # Set variable with the path to ionice.
idle='/usr/bin/idle.py -s'                      # Set variable with path to idle.py.
pctmax=12                                        # Set maxiumum frag percent needed for defrag.
                                                # This is zero here for testing purposes only
                                                # a higher number should be used in production.
array=`df -T|grep xfs|cut -f 1 --delim=" "`     # Array of all XFS file systems.
for i in ${array[@]};
do
        #check for idle flag
        if [[ $1 == "--idle" ]]
        then
            while ! $idle
            do
                echo "System is busy. Waiting 10 minutes before trying again."
                sleep 600
            done
        fi
        #check that the device is SATA and skip defrag on SSDs
        device=`echo ${i} | cut -f 3 --delim="/" | sed 's/[0-9]//g'`
        isSATA=`cat /sys/block/${device}/queue/rotational`
        if [[ $isSATA -eq 1 ]]
        then
            percentage=`$xfsdb -c frag -r ${i}|grep factor|cut -f 7 --delim=" "`
            percent2=`$e $percentage|cut -f 1 --delim=.`
            if [[ "$percent2" -gt "$pctmax" ]]
            then
                $e "${i} is $percentage fragmented. Running defragment on ${i}."
                # Only uncomment one of the following two lines.
                #$xfsfsr -v ${i}        # Uncomment for verbose defrag.
                $ionice -c3 $xfsfsr ${i}           # Uncomment for quiet defrag.
            else
                $e "${i} is $percent2% fragmented and is below the fragmentation threshold of $pctmax%. Skipping."
            fi
        else
            echo "${i} is an SSD. Skipping."
        fi
done
exit 0
