#!/bin/bash
#script to create the media directories
#used for building ISO (go.sh) and LiveCD (pre_install.sh)
#call it like so
#create_media_dirs.sh /top_level_path

topdir=$1

if [ x$topdir = "x" ]
then
    echo "Top level dir is empty"
    exit 1
fi

if [ ! -d "$topdir" ]
then
    echo "$topdir is not a dir or does not exist"
    exit 2
fi



while read dirname
do
    mkdir -p "${topdir}/${dirname}"
    touch "${topdir}/${dirname}/.media"
    chown  mythtv:users "${topdir}/${dirname}"
    chmod  775  "${topdir}/${dirname}"
    chmod  775  "${topdir}/${dirname}/.media"
done <<EOF
media/tv
media/tv/live
media/gallery
media/photos
media/music
media/games/nes/roms
media/games/nes/screens
media/games/nes
media/games/pc/screens
media/games/pc
media/games/snes/roms
media/games/snes/screens
media/games/snes
media/games/xmame/cabs
media/games/xmame/flyers
media/games/xmame/hiscores
media/games/xmame/history
media/games/xmame/roms
media/games/xmame/screens
media/games/xmame
media/games
media/video
media/tmp
media/archive
media/recordings
media/streaming
media/artwork/trailers
media/artwork/coverart
media/artwork/fanart
media/artwork/musicart
media/artwork/screenshots
media/artwork/banners
media/games/screenshots
media/games/fanart
media/games/boxart
backup
backup/system_backups
backup/user_backups
backup/mythtv_backups
EOF

chown -R mythtv:users ${topdir}
chmod -R 775  ${topdir}
chmod  1777  "${topdir}/media/tmp"
