#!/bin/bash

for vendProdID in `lsusb | sed -e 's/.*ID \([a-f0-9]\+:[a-f0-9]\+\).*/\1/g'`
do
    foundRemote=`grep -i "$vendProdID" /usr/share/linhes/templates/remotes/receiver_usb.id`
    if [[ $? = 0 ]]
    then
        #echo Found: $foundRemote
        vendID=`echo $vendProdID | cut -d":" -f1`
        prodID=`echo $vendProdID | cut -d":" -f2`
        for usbDevice in `grep . /sys/bus/usb/devices/*/power/wakeup | cut -d"/" -f6`
        do
            foundVendID=`cat /sys/bus/usb/devices/$usbDevice/idVendor`
            foundProdID=`cat /sys/bus/usb/devices/$usbDevice/idProduct`
            if [[ $foundVendID == $vendID && $foundProdID == $prodID ]]
            then
                echo "Enable wake for $foundRemote on $usbDevice"
                sudo sh -c "echo 'enabled' > /sys/bus/usb/devices/$usbDevice/power/wakeup"
            fi
        done
    fi
done
