#!/bin/bash

if [ ! -f ~/.config/lh_configured ]; then
    #cp /usr/share/linhes/templates/plasma-org.kde.plasma.desktop-appletsrc ~/.config/
    sed -i 's/launchers=.*/launchers=applications:systemsettings.desktop,preferred:\/\/filemanager,applications:org.kde.konsole.desktop,preferred:\/\/browser,applications:mythfrontend.desktop/' ~/.config/plasma-org.kde.plasma.desktop-appletsrc
    plasma-apply-wallpaperimage /usr/share/linhes/templates/lights-bud-abstract-4k-cq.jpg
    plasma-apply-colorscheme BreezeDark
fi

kwriteconfig6 --group KDE --key SingleClick false
kwriteconfig6 --file ~/.config/kscreenlockerrc --group Daemon --key Autolock false
kwriteconfig6 --file ~/.config/kscreenlockerrc --group Daemon --key LockOnResume false
kwriteconfig6 --file ~/.config/ksmserverrc --group General --key loginMode emptySession
kwriteconfig6 --file ~/.config/powermanagementprofilesrc --group AC --group DPMSControl --key idleTime --delete
kwriteconfig6 --file ~/.powerdevilrc --group AC --group Display --key DimDisplayWhenIdle false
kwriteconfig6 --file ~/.powerdevilrc --group AC --group Display --key TurnOffDisplayWhenIdle false
kwriteconfig6 --file ~/.powerdevilrc --group AC --group SuspendAndShutdown --key AutoSuspendAction 0
kwriteconfig6 --file ~/.config/donationmessage.notifyrc --group Event/ShowDonationMessage --key Action ""
kwriteconfig6 --file ~/.config/plasmanotifyrc --group Services --group donationmessage --key ShowPopups false
kwriteconfig6 --file ~/.config/plasmanotifyrc --group Services --group donationmessage --key ShowInHistory false


#sddm settings
if grep -Fxq "User=km" /etc/sddm.conf.d/autologin.conf; then
    echo "Updating /etc/sddm.conf.d/autologin.conf"
    echo "[Autologin]" | sudo tee /etc/sddm.conf.d/autologin.conf
    echo "User=$(whoami)" | sudo tee -a /etc/sddm.conf.d/autologin.conf
    echo "Session=plasmax11" | sudo tee -a /etc/sddm.conf.d/autologin.conf
fi

if [ -f "/etc/sddm.conf" ]; then
    sudo rm /etc/sddm.conf
fi

if ! grep -Fxq "[General]" /etc/sddm.conf.d/theme.conf; then
    echo "[General]" | sudo tee /etc/sddm.conf.d/theme.conf
    echo "Numlock=on" | sudo tee -a /etc/sddm.conf.d/theme.conf
    echo "[Theme]" | sudo tee -a /etc/sddm.conf.d/theme.conf
    echo "Current=breeze" | sudo tee -a /etc/sddm.conf.d/theme.conf
    echo "CursorTheme=breeze_cursors" | sudo tee -a /etc/sddm.conf.d/theme.conf
    echo "Font=Noto Sans,10,-1,0,400,0,0,0,0,0,0,0,0,0,0,1" | sudo tee -a /etc/sddm.conf.d/theme.conf
fi

#disable file indexing
balooctl6 disable
