#!/usr/bin/env python

# This script will configure the myth db to use the misc_status_info scripts

from socket import gethostname
from MythTV import MythDB
mythdb = MythDB()
localhostname = gethostname()
import sys

# Function to set db setting.  This setting is set in mythtv-setup.
def dbSettingChange():
    if mythdb.settings[localhostname].MiscStatusScript == u'':
        mythdb.settings[localhostname].MiscStatusScript = u'/usr/bin/misc_status_info.sh'
        print 'The MythTV database setting MiscStatusScript was updated to /usr/bin/misc_status_info.sh.'
    else:
        print 'The MythTV database setting MiscStatusScript is already set and will not be updated.'
    return

#taken from systemconfig.py
#this is how you populate the dict
systemconfig = {}
file_name = "/etc/systemconfig"
try:
    config_file = open(file_name)
except:
    print file_name + " could not be opened"
    sys.exit(1)

for line in config_file:
    line = line.strip()
    if line and line[0] is not "#" and line[-1] is not "=":
        var, val = line.rsplit("=", 1)
        val = val.strip('"')
        systemconfig[var.strip()] = val.strip()

#this is how you reference a value from mv_hostype.py
if (systemconfig.get("SystemType") == "Standalone"):
    dbSettingChange()
elif systemconfig.get("SystemType") == "MasterBackend":
    dbSettingChange()
