#!/usr/bin/perl -w
#
# Parses the backend log file and includes information on which encoder was used to record shows.

my ($time, $title, $subtitle, $chanid, $cardid, $sourceid);
my $index = 0;

sub print_text
{
    print "$time - $title";
    print ": $subtitle" if ($subtitle);
    print "\n";
    print " - Encoder ID: $cardid\n";
    print " - Video Source ID: $sourceid\n";
    print " -      Channel ID: $chanid\n";
}

sub print_xml
{
    print "<a href=\"javascript:void(0)\">$time - $title";
    print ": $subtitle" if ($subtitle);
    print " - Encoder: $cardid<br />".
          "<span><strong>$title</strong> $time<br />";
    print "<em>$subtitle</em><br />" if ($subtitle);
    print "<br />Channel ID: $chanid<br />Encoder ID: $cardid<br />".
          "Video Source ID: $sourceid<br /></span></a><hr />";
    # For XML parsers
    print "[]:[]capture_info$index\[]:[]time='$time':title='$title'".
          ":subtitle='$subtitle':chanid='$chanid':cardid='$cardid'".
          ":sourceid='$sourceid'\n";
}

my $mode = shift;
my $log_file = shift;

if (($mode ne "--text") && ($mode ne "--noheader"))
{
    $log_file = $mode;
}

if ($log_file =~ m/^--.*/i) 
{
    die ("Only one option can be used at a time.\n");
}

if ($log_file =~ /\.gz$/)
{   
#   read top down
#    open($fh, "gunzip -c $log_file |") or die "Unable to open log file '$log_file', stopping:";   
#   read bottom up
    open($fh, "gunzip -c $log_file |tac |") or die "Unable to open log file '$log_file', stopping:";   
}
else 
{
#   read top down
#    open($fh, "<$log_file") or die "Unable to open log file '$log_file', stopping:";
#   read bottom up
    open($fh, "tac $log_file |") or die "Unable to open log file '$log_file', stopping:";
}

while (<$fh>)
{
#   Myth .25 & .27 regex to find start of recording for digital and analog MPEG
    if (/^(\D\D\D +\d+ \d+\:\d+\:\d+)(?:.*) \(HandleRecordingStatusChange\) (?:Started|Tuning) recording: (.*): channel (\d+) on cardid \[(\d+)\], sourceid (\d+)/ || /^(\d+-\d+-\d+T\d+\:\d+\:\d+)(?:.*) \(UpdateRecStatus\) Updating status for (.*)() on cardid \[(\d+)\] \(Will Record => Recording\)()/)
    {
        if ($mode eq "--noheader")
        {
            print "<div class=\"schedule\">"
            if (($index == 0) && ($mode ne "--text"));
        }
        else
        {
            print "<h3>Encoder Information</h3><div class=\"schedule\">"
            if (($index == 0) && ($mode ne "--text"));
        }        
        $index++;

        ($time, $title, $chanid, $cardid, $sourceid) = ($1, $2, $3, $4, $5);
        $time =~ s/T/' '/;
        $time = `date -d "$time" +%a' '%-m/%-d' '%l:%M' '%p`;
        chomp ($time);
        if (($title =~ /"?(.+)"?:"?(.*)"?/) || ($title =~ /(.+) "(.*)"/))
        {
            $title = $1;
            $subtitle = $2;
        }
        else
        {
            $subtitle = '';
        }
        $title =~ s/^"//;
        $subtitle =~ s/^"//;
        $title =~ s/"$//;
        $subtitle =~ s/"$//;
        if ($mode eq "--text")
        {
            print_text;
        }
        else
        {
            print_xml;
        }
    }
}
print "</div>" if (($index > 0) && ($mode ne "--text"));

close $fh;
